define([
    'backbone',
    'modules/new-appointment-request/views/common/cancel-modal/popup-view',
    'modules/new-appointment-request/tests/helpers/general-helper',
], function(Backbone, Cancel, helpers) {
    'use strict';

    describe('Cancel Modal View', function() {
        var region;
        var modal;
        var model;

        beforeEach(function() {
            model = new Backbone.Model({entryType: 'appointment'});
            region = helpers.setupTestingRegion();
        });

        afterEach(helpers.resetTestingRegion);

        it('triggers continue', function() {
            var isCalled = false;

            region.show(new Cancel({model: model}));
            modal = region.currentView;

            modal.listenTo(modal, 'continue', function() {
                isCalled = true;
            });
            modal.continue();
            expect(isCalled).toBeTruthy();
        });

        it('calls on continue function', function() {
            var isCalled = false;
            region.show(new Cancel({
                model: model,
                onContinue: function() {
                    isCalled = true;
                },
            }));
            modal = region.currentView;
            modal.continue();
            expect(isCalled).toBeTruthy();
        });
    });
});
